async function spawn (args, options) {
    let spawnResult = {
        data: null,
        message: null,
        isException: false,
        exception: null
    };

    await cockpit.spawn(args, options)
        .then((data, message) => {
            spawnResult.isException = false;
            spawnResult.data = data;
            spawnResult.message = message;
        })
        .catch((exception, data) => {
            spawnResult.isException = true;
            spawnResult.data = data;
            spawnResult.exception = exception;
        });

    return spawnResult;
}

async function script (script, args, options) {
    let spawnResult = {
        data: null,
        message: null,
        isException: false,
        exception: null
    };
    
    await cockpit.script(script, args, options)
        .then((data, message) => {
            spawnResult.isException = false;
            spawnResult.data = data;
            spawnResult.message = message;
        })
        .catch((exception, data) => {
            spawnResult.isException = true;
            spawnResult.data = data;
            spawnResult.exception = exception;
        });

    return spawnResult;
}

export {
    spawn,
    script
}