export function beforeStart(options, extensions) {
    /* Cockpit is using urls with # sign (like .../component.html#/component-page).
    * Blazor currently doesn't support such URLs and we can't set such base URL in <base href="" /> in HTML HEAD,
    * because in such case Blazor can't load its JavaScript Initializers
    * (https://learn.microsoft.com/en-us/aspnet/core/blazor/fundamentals/startup?view=aspnetcore-7.0#javascript-initializers).
    * For instance BlazorWasmAntivirusProtection package can't be used
    * (https://github.com/stavroskasidis/BlazorWasmAntivirusProtection).
    * On the other hand the base href with "#/" is required for proper navigation in Blazor app.
    * 
    * For this reason such workaround have to be implemented:
    * 1. Add <base href="" /> tag into HEAD without "#/" in "index.html" file (it will allow to use custom Javascript
    *       Initializers, like in BlazorWasmAntivirusProtection package.
    * 2. Add "#/" to <base href="" /> tag in custom Blazor Javascript Initializer (or fully replace it like below). */
    if (window.location.pathname.startsWith('/cockpit')) {
        document.head.getElementsByTagName('base')[0].href = window.location.pathname + '#/';
    }
}

export function afterStarted(blazor) {
}